/*
 * Decompiled with CFR 0.152.
 */
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class RainbowTextGUI
extends JFrame {
    private JTextArea input;
    private JButton rainbowfy;
    private JPanel panel;
    private JTextField output;
    private JCheckBox enableBoldCheckBox;
    private JCheckBox toggleSignTextCheckBox;
    private JCheckBox useCustomRainbowCheckBox;
    private JTextField customRainbow;

    public RainbowTextGUI(String title, int width, int height) {
        super(title);
        this.$$$setupUI$$$();
        this.setSize(width, height);
        this.rainbowfy.addActionListener(e -> this.output.setText(this.getRainbowText(this.input.getText())));
        this.setContentPane(this.panel);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.output.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RainbowTextGUI.this.output.selectAll();
            }
        });
        this.output.setEditable(false);
        this.input.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                double max = RainbowTextGUI.this.toggleSignTextCheckBox.isSelected() ? 15.0 : 256.0;
                int length = RainbowTextGUI.this.input.getText().length();
                if ((double)(length *= RainbowTextGUI.this.enableBoldCheckBox.isSelected() ? 5 : 3) > max) {
                    int l = RainbowTextGUI.this.input.getText().length();
                    RainbowTextGUI.this.input.setText(RainbowTextGUI.this.input.getText().substring(0, l - 1));
                }
            }
        });
        this.input.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RainbowTextGUI.this.input.selectAll();
            }
        });
    }

    public String getRainbowText(String original) {
        char[] colors = this.useCustomRainbowCheckBox.isSelected() ? this.customRainbow.getText().toCharArray() : "ceab9d".toCharArray();
        StringBuilder sb = new StringBuilder();
        int spot = 0;
        for (char c : original.toCharArray()) {
            if (c == ' ') {
                sb.append(' ');
                continue;
            }
            sb.append('&').append(colors[spot]);
            if (this.enableBoldCheckBox.isSelected()) {
                sb.append('&').append('l');
            }
            sb.append(c);
            if (++spot <= colors.length - 1) continue;
            spot = 0;
        }
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JTextField jTextField2;
        JButton jButton;
        JTextArea jTextArea;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.input = jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setText("Input...");
        jTextArea.setWrapStyleWord(false);
        jPanel.add((Component)jTextArea, new GridConstraints(0, 0, 1, 4, 0, 3, 6, 6, null, new Dimension(150, 50), null));
        this.rainbowfy = jButton = new JButton();
        jButton.setText("Rainbowfy...");
        jPanel.add((Component)jButton, new GridConstraints(2, 0, 1, 4, 0, 1, 3, 0, null, null, null));
        this.output = jTextField2 = new JTextField();
        jTextField2.setText("Output... (Paste into Minecraft!)");
        jPanel.add((Component)jTextField2, new GridConstraints(3, 0, 1, 4, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.enableBoldCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Enable Bold");
        jPanel.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.toggleSignTextCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Toggle Sign Text");
        jPanel.add((Component)jCheckBox2, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.useCustomRainbowCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Use Custom Rainbow");
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.customRainbow = jTextField = new JTextField();
        jTextField.setText("ceab9d");
        jPanel.add((Component)jTextField, new GridConstraints(1, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

